//--------------------------------------------------------------
// Press F1 to get help about using script.
// To access an object that is not located in the current class, start the call with Globals.
// When using events and timers be cautious not to generate memoryleaks,
// please see the help for more information.
//---------------------------------------------------------------

namespace Neo.ApplicationFramework.Generated
{
    using System.Windows.Forms;
    using System;
    using System.Drawing;
    using Neo.ApplicationFramework.Tools;
    using Neo.ApplicationFramework.Common.Graphics.Logic;
    using Neo.ApplicationFramework.Controls;
    using Neo.ApplicationFramework.Interfaces;
    
    
    public partial class Tags
    {
		
		void Motor_Status_ValueChange(System.Object sender, Core.Api.DataSource.ValueChangedEventArgs e)
		{
			if (Globals.Tags.Motor_Status.Value == 0) Globals.Tags.Status_Text.Value = "Running";
			if (Globals.Tags.Motor_Status.Value == 1) Globals.Tags.Status_Text.Value = "Position Error";
			if (Globals.Tags.Motor_Status.Value == 2) Globals.Tags.Status_Text.Value = "Over Speed";
			if (Globals.Tags.Motor_Status.Value == 4) Globals.Tags.Status_Text.Value = "Over Torque";
			if (Globals.Tags.Motor_Status.Value == 8) Globals.Tags.Status_Text.Value = "Ready";
			if (Globals.Tags.Motor_Status.Value == 16) Globals.Tags.Status_Text.Value = "Disabled";
		}
		
		
		void Target_ValueChange(System.Object sender, Core.Api.DataSource.ValueChangedEventArgs e)	//The Acceleration, Speed, Position, and Save_Flag tags all trigger this when changed
		{
			Target_Change();
		}
	
		/* Any time the entered target values change, we save the values and then send them to the motor. If the motor is repowered, all of the values, including the save_flag will
			be reset, and this will trigger us to reload the values from the HMI to the motor*/
		public void Target_Change() 
		{
			Globals.Tags.Target_Acceleration.Value = Globals.Tags.Saved_Acceleration.Value;
			Globals.Tags.Target_Position.Value = Globals.Tags.Saved_Position.Value;
			Globals.Tags.Target_Speed.Value = Globals.Tags.Saved_Speed.Value;
			Globals.Tags.Save_Flag.Value=1;
		}
		

    }
}
